/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.data.filter;

import info.msxlaunchers.openmsx.launcher.data.filter.Filter;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterDescriptor;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterType;
import info.msxlaunchers.openmsx.launcher.data.filter.Value1Field;
import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.data.game.constants.VideoSource;
import info.msxlaunchers.openmsx.launcher.data.repository.RepositoryGame;
import java.util.Objects;

@FilterDescriptor(type=FilterType.VIDEO_SOURCE)
final class VideoSourceFilter
implements Filter {
    @Value1Field
    private final VideoSource videoSource;

    VideoSourceFilter(VideoSource videoSource) {
        this.videoSource = Objects.requireNonNull(videoSource);
    }

    public int hashCode() {
        return this.videoSource.hashCode();
    }

    public boolean equals(Object obj) {
        boolean isSame = obj == null || !(obj instanceof VideoSourceFilter) ? false : this.videoSource.equals(((VideoSourceFilter)obj).videoSource);
        return isSame;
    }

    @Override
    public boolean isFiltered(Game game, RepositoryGame repositoryGame) {
        Objects.requireNonNull(game);
        boolean filtered = false;
        switch (this.videoSource) {
            case MSX: {
                filtered = game.isConnectGFX9000();
                break;
            }
            case GFX9000: {
                filtered = !game.isConnectGFX9000();
                break;
            }
            default: {
                throw new RuntimeException("Update filter if Medium contains an extra medium");
            }
        }
        return filtered;
    }
}

